package FlashReader;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Header extends SwfTools{
	
	private int signature1; //UI8
	private int signature2; //UI8
	private int signature3; //UI8
	private int version; //UI8
	private int fileLength; //UI32
	private int Xmin;
	private int Xmax;
	private int Ymin;
	private int Ymax;
	private int frameRate; //UI16
	private int frameCount; //UI16
	
	public Header(){
		
	}

	public int getSignature1() {
		return signature1;
	}

	public void setSignature1(int signature1) {
		this.signature1 = signature1;
	}

	public int getSignature2() {
		return signature2;
	}

	public void setSignature2(int signature2) {
		this.signature2 = signature2;
	}

	public int getSignature3() {
		return signature3;
	}

	public void setSignature3(int signature3) {
		this.signature3 = signature3;
	}

	public int getVersion() {
		return version;
	}

	public void setVersion(int version) {
		this.version = version;
	}

	public int getFileLength() {
		return fileLength;
	}

	public void setFileLength(int fileLength) {
		this.fileLength = fileLength;
	}

	public int getXmin() {
		return Xmin/20;
	}

	public void setXmin(int xmin) {
		Xmin = xmin;
	}

	public int getXmax() {
		return Xmax/20;
	}

	public void setXmax(int xmax) {
		Xmax = xmax;
	}

	public int getYmin() {
		return Ymin/20;
	}

	public void setYmin(int ymin) {
		Ymin = ymin;
	}

	public int getYmax() {
		return Ymax/20;
	}

	public void setYmax(int ymax) {
		Ymax = ymax;
	}

	public int getFrameRate() {
		return frameRate;
	}

	public void setFrameRate(int frameRate) {
		this.frameRate = frameRate;
	}

	public int getFrameCount() {
		return frameCount;
	}

	public void setFrameCount(int frameCount) {
		this.frameCount = frameCount;
	}
	
	public static String printHeader(){
		
		return null;
	}
	
	public boolean isCompressed(){
		if(signature1 == 'C') return true;
		return false;
	}
	
	private ByteBuffer getRect(){
		String xminS = Integer.toBinaryString(Xmin);
		int nBits = xminS.length();
		
		String xmaxS = Integer.toBinaryString(Xmax);
		if(xmaxS.length()> nBits)nBits = xmaxS.length();
		
		String yminS = Integer.toBinaryString(Ymin);
		if(yminS.length()> nBits)nBits = yminS.length();
		
		String ymaxS = Integer.toBinaryString(Ymax);
		if(ymaxS.length()> nBits)nBits = ymaxS.length();
		
		nBits+=1; //poniewaz musi byc unsigned czyli dodatkowo 0 aby nie bylo 1 na poczatku slowa
		
		String nBitsS = Integer.toBinaryString(nBits);

		int res = 5 + nBits*4;
		
		while (res%8 != 0 ){
			res+=1;
		}
		nBitsS = dopelnienie(5,nBitsS);
		xminS = dopelnienie(nBits,xminS);
		xmaxS = dopelnienie(nBits,xmaxS);
		yminS = dopelnienie(nBits,yminS);
		ymaxS = dopelnienie(nBits,ymaxS);

		
		String wordBit = nBitsS + xminS + xmaxS + yminS + ymaxS;

		wordBit = dopelnienie2(res,wordBit);
		ByteBuffer bbuf = ByteBuffer.allocate((res/8));
		bbuf.order(ByteOrder.BIG_ENDIAN);
		
		int licznik=0;
		for ( int i =0; i < res/8; i++){
			bbuf.put( (byte)Integer.parseInt( (wordBit.substring(licznik, licznik+8 ) ) ,2 ) ); //poniewa nie moe by 10000000
			licznik+=8;
		}
		bbuf.position(0);

		return bbuf;
	}
	
	
	
	public ByteBuffer getBytes(){
		ByteBuffer bbufRect = getRect();
		ByteBuffer bbuf = ByteBuffer.allocate(12+bbufRect.capacity());
		bbuf.order(ByteOrder.LITTLE_ENDIAN);
		
		bbuf.put((byte)signature1);
		bbuf.put((byte)signature2);
		bbuf.put((byte)signature3);
		bbuf.put((byte)version);
		bbuf.putInt(fileLength);
		bbuf.put(bbufRect);
		bbuf.putShort( Short.reverseBytes((short) frameRate));
		bbuf.putShort((short) frameCount);

		bbuf.position(0);
		return bbuf;
	}
	
	/**
	 * Dopelnienie od lewej
	 * @param len
	 * @param bits
	 * @return
	 */
	private String dopelnienie(int len, String bits){
		if (bits.length()<len){
			String result = "";
			for (int i =0; i < len -bits.length(); i++ )
				result+="0";
			return result + bits;
		}
		return bits;
	}
	
	/**
	 * Dopelnienie od prawej
	 * @param len
	 * @param bits
	 * @return
	 */
	private String dopelnienie2(int len, String bits){
		if (bits.length()<len){
			String result = bits;
			for (int i =0; i < len -bits.length(); i ++ )
				result+="0";
			return result;
		}
		return bits;
	}
	
	public void swfRect(){
		;
	}
	


}
